from typing import List, Dict

# Données de départ
achats: List[Dict] = [
    {"libelle": "Casse-croute", "montant": 500, "categorie": "nourriture"},
    {"libelle": "Cinéma", "montant": 1200, "categorie": "loisir"},
    {"libelle": "Plein de scooter", "montant": 2000, "categorie": "transport"},
    {"libelle": "Paquet de mangue", "montant": 500, "categorie": "nourriture"},
    {"libelle": "Ticket de bus", "montant": 200, "categorie": "transport"}
]

# Initialiser le dictionnaire qui contiendra les totaux par catégorie
depenses_par_categorie: Dict = {}

# Parcourir la liste des achats
for achat in achats:
    categorie: str = achat["categorie"]
    montant: int = achat["montant"]

    # Si la catégorie existe déjà, on ajoute le montant.
    # Sinon, on la crée avec le montant actuel.
    if categorie in depenses_par_categorie:
        depenses_par_categorie[categorie] += montant
    else:
        depenses_par_categorie[categorie] = montant

# Afficher le résultat pour vérifier
print(depenses_par_categorie)
